<?php

namespace App\Http\Controllers\Payments;
use App\Events\TransactionPaid;
use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;
use GuzzleHttp\Client;

class bangopaybdController extends Controller
{
    private $paymentGateway;
    private $apiKey;

    public function __construct()
    {
        $this->paymentGateway = paymentGateway('bangopaybd');
        $this->apiKey = $this->paymentGateway->credentials->api_key;
    }

    public function process(Transaction $trx)
    {
        $user = $trx->user;
        $client = new Client();
        $amountInBDT = $trx->total * 100;
$clientDomain = $_SERVER['HTTP_HOST'];
        $response = $client->post('https://payment.bangopaybd.com/api/payment/checkout', [
            'headers' => [
                'Content-Type' => 'application/json',
                'X-API-KEY' => $this->apiKey,
                 "X-CLIENT: " . $clientDomain
            ],
            'json' => [
                'success_url' => route('payments.ipn.bangopaybd').'?trx='.$trx->id,
                'cancel_url'  => route('checkout.index', hash_encode($trx->id)),
                'webhook_url' => route('payments.webhooks.bangopaybd'),
                'fullname' => $user->getName(),
                'email' => $user->email,
                'amount' => number_format($amountInBDT, 2, '.', ''),
                'meta_data' => json_encode([
                    'phone' => $user->phone
                ]),
            ]
        ]);

        $result = json_decode($response->getBody(), true);

        if (isset($result['status']) && $result['status'] == 1) {
            return json_encode([
                'type' => 'success',
                'method' => 'redirect',
                'redirect_url' => $result['payment_url']
            ]);
        }

        return json_encode([
            'type' => 'error',
            'msg' => $result['message'] ?? 'Unexpected API response structure.'
        ]);
    }

    public function ipn(Request $request)
    {
        $trxid = $_GET['trx'];
        $transactionId = $_GET['transactionId'];
        $trx = Transaction::where('id', $trxid)->firstOrFail();

        if ($trx->isPaid()) {
            return redirect()->route('checkout.index', hash_encode($trxid));
        }

        return $this->verifyPayment($trx, $transactionId);
    }

    public function webhook(Request $request)
    {
        $payload = $request->all();
        if (isset($payload['transaction_id'])) {
            $transactionId = $payload['transaction_id'];
            $trx = Transaction::where('payment_id', $transactionId)->first();

            if ($trx && $payload['status'] === 'COMPLETED') {
                $trx->status = Transaction::STATUS_PAID;
                $trx->update();
                event(new TransactionPaid($trx));
            }
        }

        return response('Webhook received', 200);
    }
    private function verifyPayment(Transaction $trx, $transactionId)
    {
        $client = new Client();
        $response = $client->post('https://payment.bangopaybd.com/api/payment/verify-payment', [
            'headers' => [
                'Content-Type' => 'application/json',
                'X-API-KEY' => $this->apiKey
            ],
            'json' => [
                'transaction_id' => $transactionId
            ]
        ]);
        
        $result = json_decode($response->getBody(), true);
        if ($result['status'] === 'COMPLETED') {
            $trx->status = Transaction::STATUS_PAID;
            $trx->update();
            $trx->user->emptyCart();
            event(new TransactionPaid($trx));
            return redirect()->route('checkout.index', hash_encode($trx->id));
        }

        return redirect()->route('checkout.index', hash_encode($trx->id));
    }
}
